/*
**	Copyright (C) 2006-2008  bCODE Pty Ltd (www.bcode.com)
**	Written and maintained by Erik de Castro Lopo <erikd@mega-nerd.com>
**
**	This program is free software: you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation, either version 3 of the License, or
**	(at your option) any later version.
**
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
**	You should have received a copy of the GNU General Public License
**	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "zytouch_usb.h"


void
read_v2_config (const char * filename, CONFIG_V2 * config)
{
	FILE * file ;
	char buffer [128], * cptr ;
	int temp, sense = -1 ;

	memset (config, 0, sizeof (*config)) ;

	if ((file = fopen (filename, "r")) == NULL)
	{	printf ("Error : Could not read config file '%s'\n", filename) ;
		exit (1) ;
		} ;

	while (fgets (buffer, sizeof (buffer), file) != NULL)
	{	cptr = buffer ;
		while (isspace (cptr [0]))
			cptr ++ ;
		if (cptr [0] == 0 || cptr [0] == '#')
			continue ;
		if (sscanf (cptr, "sense threshold : %d", &temp) == 1)
			config->sensitivity = temp ;
		if (sscanf (cptr, "sense range : %d", &temp) == 1)
			config->range = temp ;
		if (sscanf (cptr, "x edge gain * 10 : %d", &temp) == 1)
			config->xedgegain = temp ;
		if (sscanf (cptr, "y edge gain * 10 : %d", &temp) == 1)
			config->yedgegain = temp ;
		if (sscanf (cptr, "x scale * 10 : %d", &temp) == 1)
			config->xscale = temp ;
		if (sscanf (cptr, "x offset : %d", &temp) == 1)
			config->xoff = temp ;
		if (sscanf (cptr, "y scale * 10 : %d", &temp) == 1)
			config->yscale = temp ;
		if (sscanf (cptr, "y offset : %d", &temp) == 1)
			config->yoff = temp ;

		} ;

	fclose (file) ;

	if (config->sensitivity < 4 || config->sensitivity > 32)
	{	printf ("Error %s : sense threshold value (%d) should be in the range 4-32.\n", __func__, sense) ;
		exit (1) ;
		} ;

} /* read_v2_config */

void
read_v3_config (const char * filename, CONFIG_V3 * config)
{
	FILE * file ;
	char buffer [128], * cptr ;
	float ftemp ;
	int itemp ;

	memset (config, 0, sizeof (*config)) ;

	if ((file = fopen (filename, "r")) == NULL)
	{	printf ("Error : Could not read config file '%s'\n", filename) ;
		printf ("Using default calibrate settings. Please run zytouch-calibrate.\n") ;

		config->swap_xy = 0 ;

		config->x_gain = 0.5 ;
		config->x_offset = 0.0 ;
		config->y_gain = 0.5 ;
		config->y_offset = 0.0 ;

		config->threshold_fw3 = 10 ;
		config->frame_avg = 3 ;
		config->glass_thickness = 2 ;

		return ;
		} ;

	while (fgets (buffer, sizeof (buffer), file) != NULL)
	{	char boolean [16] ;

		cptr = buffer ;
		while (isspace (cptr [0]))
			cptr ++ ;
		if (cptr [0] == 0 || cptr [0] == '#')
			continue ;

		if (sscanf (cptr, "swap_xy : %12[a-z]", boolean) == 1)
		{	if (strcmp (boolean, "true") == 0)
				config->swap_xy = 1 ;
			else if (strcmp (boolean, "false") == 0)
				config->swap_xy = 0 ;
			}
		else if (sscanf (cptr, "x_gain : %f", &ftemp) == 1)
			config->x_gain = ftemp ;
		else if (sscanf (cptr, "x_offset : %f", &ftemp) == 1)
			config->x_offset = ftemp ;
		else if (sscanf (cptr, "y_gain : %f", &ftemp) == 1)
			config->y_gain = ftemp ;
		else if (sscanf (cptr, "y_offset : %f", &ftemp) == 1)
			config->y_offset = ftemp ;

		else if (sscanf (cptr, "threshold_fw3 : %d", &itemp) == 1)
			config->threshold_fw3 = itemp ;

		else if (sscanf (cptr, "frame_avg : %d", &itemp) == 1)
			config->frame_avg = itemp ;
		else if (sscanf (cptr, "glass_thickness : %d", &itemp) == 1)
			config->glass_thickness = itemp ;
		} ;

	fclose (file) ;


} /* read_v3_config */
