/*
**	Copyright (C) 2006-2008  bCODE Pty Ltd (www.bcode.com)
**	Written and maintained by Erik de Castro Lopo <erikd@mega-nerd.com>
**
**	This program is free software: you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation, either version 3 of the License, or
**	(at your option) any later version.
**
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
**	You should have received a copy of the GNU General Public License
**	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include <unistd.h>
#include <signal.h>

#include "zytouch_usb.h"

static const char * pid_filename = "/var/run/zytouchd.pid" ;

static void
quit_handler (int unused __attribute ((unused)))
{	unlink (pid_filename) ;
	exit (0) ;
} /* remove_pid_file */


void
daemonize (void)
{	FILE *file ;
	struct sigaction sigact ;

	if (access (pid_filename, F_OK) == 0)
	{	if ((file = fopen (pid_filename, "r")) != NULL)
		{	char pid_str [32] ;
			if (fgets (pid_str, sizeof (pid_str), file) != NULL)
			{	pid_t pid = atoi (pid_str) ;
				if (pid > 0)
					kill (pid, SIGQUIT) ;
				} ;

			fclose (file) ;
			} ;

		unlink (pid_filename) ;
		} ;

	/* Change to root dir. */
	if (chdir ("/") != 0)
	{	printf ("chdir : %s\n", strerror (errno)) ;
		exit (1) ;
		} ;

	/* Ignore SIGCHLD. */
	signal (SIGCHLD, SIG_IGN) ;

	pid_t pid = fork () ;

	if (pid == -1)
	{	printf ("Error : fork failed : %s\n", strerror (errno)) ;
		exit (1) ;
		} ;

	if (pid != 0)
		_exit (0) ;

	/* Install SIGQUIT handler so we can delete the PID file. */
 	memset (&sigact, 0, sizeof (sigact)) ;
	sigact.sa_handler = quit_handler ;
	sigaction (SIGQUIT, &sigact, NULL) ;

#if 0
	/* This will be needed when it really does become a daemon. */
	if ((file = fopen (pid_filename, "w")) == NULL)
	{	printf ("Cannot write to file '%s'. Exiting.\n", pid_filename) ;
		exit (1) ;
		} ;

	fprintf (file, "%d\n", getpid ()) ;
	fclose (file) ;
#endif

	setsid () ;

} /* daemonize */

int
int_of_string (const char * str, int len)
{
	int k, value = 0 ;

	for (k = 0 ; k < len ; k++)
	{
		if (isdigit (str [k]) == 0)
			return -1 ;

		value = value * 10 + str [k] - '0' ;
		} ;

	return value ;
} /* int_of_string */
