/*
**	Copyright (C) 2006-2008  bCODE Pty Ltd (www.bcode.com)
**	Written and maintained by Erik de Castro Lopo <erikd@mega-nerd.com>
**
**	This program is free software: you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation, either version 3 of the License, or
**	(at your option) any later version.
**
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
**	You should have received a copy of the GNU General Public License
**	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <usb.h>
#include <X11/Xlib.h>

typedef struct
{	int vendor, product ;
	usb_dev_handle* handle ;
} ZYTOUCH ;

typedef struct
{	int daemon_mode ;
	int debug ;
} CONFIG_COMMON ;

typedef struct
{	/* Command line config parameters. */
	CONFIG_COMMON common ;

	/* Read from the config file. */
	int sensitivity ;
	int range ;
	int xedgegain ;
	int yedgegain ;
	int xscale ;
	int xoff ;
	int yscale ;
	int yoff ;
} CONFIG_V2 ;

typedef struct
{	/* Command line config parameters. */
	CONFIG_COMMON common ;

	/* Swap X/Y coordinates. */
	int	swap_xy ;

	/* Read from the config file. */
	float x_gain ;
	float x_offset ;
	float y_gain ;
	float y_offset ;

	int frame_avg ; /* 0 - 9 */
	int glass_thickness ; /* 0 - 3 */

	/*
	**	Only fiddle threshold when on firmware version >= 3.
	*/
	int threshold_fw3 ;
} CONFIG_V3 ;

/* Only used for V3 for now. */
extern int g_reload_config ;

int find_handle_retry (ZYTOUCH * zyt) ;

void handle_zytouch (Display *display, const CONFIG_COMMON * config) ;


/* In config.c */
void read_v2_config (const char * filename, CONFIG_V2 * config) ;

void read_v3_config (const char * filename, CONFIG_V3 * config) ;

/* In util.c */
void daemonize (void) ;
int int_of_string (const char * str, int len) ;
