/*
**	Copyright (C) 2006-2008  bCODE Pty Ltd (www.bcode.com)
**	Written and maintained by Erik de Castro Lopo <erikd@mega-nerd.com>
**
**	This program is free software: you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation, either version 3 of the License, or
**	(at your option) any later version.
**
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
**	You should have received a copy of the GNU General Public License
**	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include <errno.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XTest.h>

#include <stdarg.h>
#include <syslog.h>

#include "zytouch_usb.h"
#include "debug.h"
#include "version.h"

static void
syslog_barf (const char * fmt, ...)
{
	va_list argp ;

	openlog ("zytouchd", LOG_NDELAY, LOG_DAEMON) ;

	va_start (argp, fmt) ;
	vsyslog (LOG_ERR, fmt, argp) ;
	va_end (argp) ;

	closelog () ;
} /* syslog_barf */

static Display *
get_display (void)
{	const char * display_name = ":0.0" ;
	Display    *dpy ;
	Bool success ;
	int dummy, xtest_major_version, xtest_minor_version ;

    if ((dpy = XOpenDisplay (display_name)) == NULL)
	{	syslog_barf ("Error : can't open display '%s'\n", XDisplayName (display_name)) ;
        exit (1) ;
    	} ;

    success = XTestQueryExtension (dpy, &dummy, &dummy, &xtest_major_version, &xtest_minor_version) ;
    if(success == False || xtest_major_version < 2 || (xtest_major_version <= 2 && xtest_minor_version < 2))
	{	syslog_barf ("XTEST extension not supported") ;
        exit (1) ;
    	} ;

	return dpy ;
} /* get_display */

static void
version_exit (const char * progname)
{
	printf ("\n%s version %s\n\n", progname, SVN_VERSION) ;
	exit (0) ;
}

static void
usage_exit (const char * progname)
{
	printf ("\n%s (version %s)\n\n", progname, SVN_VERSION) ;

	puts (
		"    -h  |  --help       This help message.\n"
		"    -d  |  --debug      Turn on debug to stdout (won't daemonize).\n"
		"    -f  |  --fg         Run in foreground (ie won't daemonize).\n"
		"    -V  |  --version    Run in foreground (ie won't daemonize).\n"
		) ;

	exit (0) ;
} /* usage_exit */

static void
handle_args (int argc, char * argv [], CONFIG_COMMON * config)
{	const char * progname ;
	int k ;

	progname = strrchr (argv [0], '/') ;
	progname = progname ? progname + 1 : argv [0] ;

	for (k = 1 ; k < argc ; k++)
	{
		if (strcmp (argv [k], "-V") == 0 || strcmp (argv [k], "-v") == 0 || strcmp (argv [k], "--version") == 0)
			version_exit (progname) ;

		if (strcmp (argv [k], "-h") == 0 || strcmp (argv [k], "--help") == 0)
			usage_exit (progname) ;

		if (strcmp (argv [k], "-f") == 0 || strcmp (argv [k], "--fg") == 0)
		{	config->daemon_mode = 0 ;
			continue ;
			} ;

		if (strcmp (argv [k], "-d") == 0 || strcmp (argv [k], "--debug") == 0)
		{	set_debug (1) ;
			config->debug = 1 ;
			config->daemon_mode = 0 ;
			continue ;
			} ;

		printf ("Error, unknow command lime parameter '%s'\n", argv [k]) ;
		exit (1) ;
		} ;

	return ;
} /* handle_args */

int
main (int argc, char * argv [])
{	Display *display ;
	CONFIG_COMMON config ;

	memset (&config, 0, sizeof (config)) ;

	/* Daemon mode is the default. */
	config.daemon_mode = 1 ;

	if (argc > 1)
		handle_args (argc, argv, &config) ;

#if 0
	/* This will be needed when it really does become a daemon. */
	if (getuid () != 0 && seteuid (0) != 0)
	{	const char * progname ;
		progname = strrchr (argv [0], '/') ;
		if (progname == NULL)
			progname = argv [0] ;
		else
			progname ++ ;
		printf ("\nError : '%s' cannot seteuid to root. Exiting.\n\n", progname) ;
		exit (0) ;
		} ;
#endif

	display = get_display () ;

	setvbuf (stdout, NULL, _IONBF, 0) ;

	handle_zytouch (display, &config) ;

	return 0 ;
} /* main */
